/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.io.fru;

import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccess;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccessFactory;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementException;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.TextAndRadiobuttonGroupDataBean;
import com.ibm.hwmca.fw.service.panel.TextOnlyDataBean;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.service.fru.RVBaseFru;
import com.ibm.hwmca.p.service.io.IOPlanarFru;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonUnconfigIOBackplaneDevices10;
import com.ibm.hwmca.xfw.service.panel.PBCommonUnconfigIOBackplaneDevices20;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class PIPciBackplane
extends RVBaseFru
implements IOPlanarFru {
    protected String infoCenterFileName = "iphau/offexpansion.htm";
    protected String referenceCodeTitleString = "Reference Code";

    protected String makeInfoCenterURL(String ipaddr, Locale locale) {
        Trace.trace("XRVFRUNT", "-> PIPciBackplane.makeURL (locale=" + locale + ")");
        String correctUrl = ":4411/eserver/HW/" + locale.getLanguage() + "_" + locale.getCountry() + "/info/";
        String enUsUrl = ":4411/eserver/HW/en_US/info/";
        if (correctUrl.length() != enUsUrl.length()) {
            Trace.trace("XRVFRUNF", "PIPciBackplane.makeURL unknown/unsupported locale[" + locale + "], using en_US");
            correctUrl = enUsUrl;
        }
        String retUrl = "http://" + ipaddr + correctUrl + this.infoCenterFileName;
        Trace.trace("XRVFRUNT", "<- PIPciBackplane.makeURL: " + retUrl);
        return retUrl;
    }

    protected String getHMCIpAddr() throws Exception {
        String ipaddr;
        block7: {
            Trace.trace("XRVFRUNT", "-> PIPciBackplane.getHMCIpAddr");
            ipaddr = null;
            String toms_hn = null;
            String name = null;
            String domain = null;
            try {
                ipaddr = InetAddress.getLocalHost().getHostAddress();
                if (ipaddr != null) {
                    Trace.trace("XRVFRUNF", "-- HMC hostname returned from getHostAddress() call is <" + ipaddr + ">");
                    break block7;
                }
                Trace.trace("XRVFRUNF", "-- HMC hostname returned is null, trying alternate hostname...");
                try {
                    name = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                    domain = NetworkSettings.getNetworkSettings().getNetworkInfo().getDomainName();
                    toms_hn = domain != null ? name + "." + domain : name;
                    Trace.trace("XRVFRUNF", "-- HMC hostname returned from Network Settings call is <" + toms_hn + ">");
                    ipaddr = toms_hn;
                }
                catch (Exception e) {
                    Trace.trace("XRVFRUNF", "-- NetworkSettings exception is " + e + ", rethrowing...");
                    throw e;
                }
            }
            catch (UnknownHostException uhe) {
                Trace.trace("XRVFRUNF", "-- caught unknown host exception, try alternate call...>");
                try {
                    name = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                    domain = NetworkSettings.getNetworkSettings().getNetworkInfo().getDomainName();
                    toms_hn = domain != null ? name + "." + domain : name;
                    Trace.trace("XRVFRUNF", "-- HMC hostname returned from Network Settings call is <" + toms_hn + ">");
                    ipaddr = toms_hn;
                }
                catch (Exception e) {
                    Trace.trace("XRVFRUNF", "-- NetworkSettings exception is " + e);
                    throw e;
                }
            }
        }
        Trace.trace("XRVFRUNT", "<- PIPciBackplane.getHMCIpAddr");
        return ipaddr;
    }

    public void displayServiceEffect(Map userData) throws ServiceableElementException {
        Trace.trace("XRVFRUNT", "-> BandCPciBackplane.displayServiceEffect");
        boolean delay = false;
        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
        HashMap<String, Object> displayMap = new HashMap<String, Object>();
        TextAndRadiobuttonGroupDataBean bean = new PBCommonUnconfigIOBackplaneDevices10();
        bean.setDataMap(displayMap);
        try {
            bean = (TextAndRadiobuttonGroupDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData);
        }
        catch (Exception e) {
            Trace.trace("XRVFRUNT", "<-! guiHandle.replace exception caught: " + e);
            Trace.trace("XRVFRUNT", e);
            throw new ServiceableElementException(e);
        }
        if (bean.isFirstRadioButtonSelected()) {
            String hmcIPAddress;
            Locale clientLocale = Locale.US;
            try {
                hmcIPAddress = this.getHMCIpAddr();
            }
            catch (Exception e) {
                Trace.trace("XRVFRUNT", "PIPciBackplane.start exception caught getting hmc ip addres; using 127.0.0.1");
                hmcIPAddress = "127.0.0.1";
            }
            ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
            ExternalDataAccess eda = null;
            try {
                ExternalDataAccessFactory edaf = (ExternalDataAccessFactory)ms.getFactory("ExternalDataAccessFactory");
                if (edaf == null) {
                    Trace.trace("XRVFRUNT", "<-! PIPciBackplane.start ExternalDataAccessFactory not set in userData");
                    throw new ServiceActionException("ExternalDataAccessFactory not set in userData");
                }
                eda = edaf.create(null);
            }
            catch (Exception e) {
                Trace.trace("XRVFRUNT", "<-! PIPciBackplane.start undable to create ExternalDataAccess, exception=" + e);
                Trace.trace("XRVFRUNT", e);
            }
            displayMap.put("EXTERNAL_DATA_ACCESS", eda);
            displayMap.put("HMC_HOSTNAME", hmcIPAddress);
            eda.setToken((Serializable)((Object)this.makeInfoCenterURL(hmcIPAddress, clientLocale)));
            TextOnlyDataBean bean2 = new PBCommonUnconfigIOBackplaneDevices20();
            bean2.setDataMap(displayMap);
            try {
                bean2 = (TextOnlyDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean2.getTemplateName(), bean2, userData);
            }
            catch (Exception e) {
                Trace.trace("XRVFRUNT", "<-! guiHandle.replace exception caught: " + e);
                Trace.trace("XRVFRUNT", e);
                throw new ServiceableElementException(e);
            }
        }
        delay = true;
        try {
            Context context = (Context)userData.get("STS_CONTEXT");
            context.getVariable(SD.USER_SELECTION_VARIABLE).setValue(SD.DELAY);
            context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
        }
        catch (Exception e) {
            Trace.trace("XRVFRUNT", "<-! PIDefaultBpaFru.displayServiceEffect exception caught setting OVERALL_STATUS to DELAY: " + e);
            Trace.trace("XRVFRUNT", e);
            throw new ServiceableElementException("exception caught setting OVERALL_STATUS to DELAY: " + e);
        }
        Trace.trace("XRVFRUNT", "<- BandCPciBackplane.displayServiceEffect");
        if (!delay) {
            super.displayServiceEffect(userData);
        }
    }
}

